/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.generating;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityGeneratingFlower;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.common.helper.ExperienceHelper;

public class SubTileArcaneRose
extends TileEntityGeneratingFlower {
    private static final int MANA_PER_XP = 50;
    private static final int MANA_PER_XP_ORB = 35;
    private static final int RANGE = 1;

    public SubTileArcaneRose(BlockPos pos, BlockState state) {
        super(ModSubtiles.ROSA_ARCANA, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.f_58857_.f_46443_ || this.getMana() >= this.getMaxMana()) {
            return;
        }
        AABB effectBounds = new AABB(this.getEffectivePos().m_142082_(-1, -1, -1), this.getEffectivePos().m_142082_(2, 2, 2));
        List players = this.m_58904_().m_45976_(Player.class, effectBounds);
        for (Object player : players) {
            if (ExperienceHelper.getPlayerXP((Player)player) < 1 || !player.m_20096_()) continue;
            ExperienceHelper.drainPlayerXP((Player)player, 1);
            this.addMana(50);
            this.sync();
            return;
        }
        List orbs = this.m_58904_().m_45976_(ExperienceOrb.class, effectBounds);
        for (ExperienceOrb orb : orbs) {
            if (!orb.m_6084_()) continue;
            this.addMana(orb.m_20801_() * 35);
            orb.m_146870_();
            float pitch = (this.f_58857_.f_46441_.nextFloat() - this.f_58857_.f_46441_.nextFloat()) * 0.35f + 0.9f;
            this.f_58857_.m_5594_(null, this.getEffectivePos(), SoundEvents.f_11871_, SoundSource.BLOCKS, 0.07f, pitch);
            this.sync();
            return;
        }
        List items = this.m_58904_().m_6443_(ItemEntity.class, effectBounds, e -> e.m_6084_() && !e.m_32055_().m_41619_());
        for (ItemEntity entity : items) {
            int xp;
            ItemStack stack = entity.m_32055_();
            if (!stack.m_150930_(Items.f_42690_) && !stack.m_41793_() || (xp = SubTileArcaneRose.getEnchantmentXpValue(stack)) <= 0) continue;
            ItemStack newStack = SubTileArcaneRose.removeNonCurses(stack);
            newStack.m_41764_(1);
            stack.m_41774_(1);
            ItemEntity newEntity = new ItemEntity(this.f_58857_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), newStack);
            newEntity.m_20256_(entity.m_20184_());
            this.f_58857_.m_7967_((Entity)newEntity);
            this.f_58857_.m_5594_(null, this.getEffectivePos(), ModSounds.arcaneRoseDisenchant, SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.nextFloat() * 0.1f + 0.9f);
            while (xp > 0) {
                int i = ExperienceOrb.m_20782_((int)xp);
                xp -= i;
                this.f_58857_.m_7967_((Entity)new ExperienceOrb(this.f_58857_, (double)this.getEffectivePos().m_123341_() + 0.5, (double)this.getEffectivePos().m_123342_() + 0.5, (double)this.getEffectivePos().m_123343_() + 0.5, i));
            }
            return;
        }
    }

    private static int getEnchantmentXpValue(ItemStack stack) {
        int ret = 0;
        Map map = EnchantmentHelper.m_44831_((ItemStack)stack);
        for (Map.Entry entry : map.entrySet()) {
            Enchantment enchantment = (Enchantment)entry.getKey();
            Integer integer = (Integer)entry.getValue();
            if (enchantment.m_6589_()) continue;
            ret += enchantment.m_6183_(integer.intValue());
        }
        return ret;
    }

    private static ItemStack removeNonCurses(ItemStack stack) {
        ItemStack itemstack = stack.m_41777_();
        itemstack.m_41749_("Enchantments");
        itemstack.m_41749_("StoredEnchantments");
        Map<Enchantment, Integer> map = EnchantmentHelper.m_44831_((ItemStack)stack).entrySet().stream().filter(p_217012_0_ -> ((Enchantment)p_217012_0_.getKey()).m_6589_()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        EnchantmentHelper.m_44865_(map, (ItemStack)itemstack);
        itemstack.m_41742_(0);
        if (itemstack.m_150930_(Items.f_42690_) && map.size() == 0) {
            itemstack = new ItemStack((ItemLike)Items.f_42517_);
            if (stack.m_41788_()) {
                itemstack.m_41714_(stack.m_41786_());
            }
        }
        for (int i = 0; i < map.size(); ++i) {
            itemstack.m_41742_(AnvilMenu.m_39025_((int)itemstack.m_41610_()));
        }
        return itemstack;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 1);
    }

    @Override
    public int getColor() {
        return 0xFF8EF8;
    }

    @Override
    public int getMaxMana() {
        return 6000;
    }
}

